/*
 * Decompiled with CFR 0.152.
 */
package com.android.print.sdk.wifi;

import android.os.Handler;
import android.util.Log;
import com.android.print.sdk.IPrinterPort;
import com.android.print.sdk.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;

public class WiFiPort
implements IPrinterPort {
    private static String TAG = "WifiPrinter";
    private String address;
    private int port;
    private Socket mSocket;
    private OutputStream outputStream;
    private InputStream inputStream;
    private ConnectThread mConnectThread;
    private Handler mHandler;
    private int mState;
    private int readLen;

    public WiFiPort(String ipAddress, int portNumber, Handler handler) {
        this.address = ipAddress;
        this.port = portNumber;
        this.mHandler = handler;
        this.mState = 103;
    }

    @Override
    public void open() {
        Utils.Log(TAG, "open connect to: " + this.address);
        if (this.mState != 103) {
            this.close();
        }
        Log.v((String)"wifitest", (String)"enter");
        this.mConnectThread = new ConnectThread();
        this.mConnectThread.start();
    }

    @Override
    public void close() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.outputStream = null;
        this.inputStream = null;
        this.mSocket = null;
        this.mConnectThread = null;
        if (this.mState != 102) {
            this.setState(103);
        }
    }

    @Override
    public int write(byte[] data) {
        block3: {
            try {
                if (this.outputStream != null) {
                    this.outputStream.write(data);
                    this.outputStream.flush();
                    break block3;
                }
                return -1;
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }
        return 0;
    }

    @Override
    public byte[] read() {
        int firstByte;
        byte[] readBuff;
        block6: {
            readBuff = null;
            firstByte = 0;
            if (this.inputStream == null || (firstByte = this.inputStream.read()) != -1) break block6;
            this.setState(103);
            return null;
        }
        try {
            if (this.inputStream != null && (this.readLen = this.inputStream.available()) > 0) {
                readBuff = new byte[this.readLen];
                this.inputStream.read(readBuff);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (firstByte > 0) {
            if (readBuff == null) {
                return new byte[]{(byte)firstByte};
            }
            byte[] by = new byte[readBuff.length + 1];
            by[0] = (byte)firstByte;
            System.arraycopy(readBuff, 0, by, 1, readBuff.length);
            readBuff = by;
        }
        Log.w((String)TAG, (String)("read length:" + this.readLen));
        return readBuff;
    }

    public int read1() {
        int readValue = -1;
        try {
            readValue = this.inputStream.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return readValue;
    }

    private synchronized void setState(int state) {
        Utils.Log(TAG, "setState() " + this.mState + " -> " + state);
        if (this.mState != state) {
            this.mState = state;
            if (this.mHandler != null) {
                this.mHandler.obtainMessage(this.mState).sendToTarget();
            }
        }
    }

    @Override
    public int getState() {
        return this.mState;
    }

    public Boolean isServerClose() {
        try {
            this.mSocket.sendUrgentData(255);
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    private class ConnectThread
    extends Thread {
        private ConnectThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean hasError = true;
            InetSocketAddress mSocketAddress = new InetSocketAddress(WiFiPort.this.address, WiFiPort.this.port);
            try {
                WiFiPort.this.mSocket = new Socket();
                WiFiPort.this.mSocket.setSoTimeout(5000);
                WiFiPort.this.mSocket.connect(mSocketAddress, 5000);
                WiFiPort.this.outputStream = WiFiPort.this.mSocket.getOutputStream();
                WiFiPort.this.inputStream = WiFiPort.this.mSocket.getInputStream();
                hasError = false;
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                WiFiPort.this.mConnectThread = null;
            }
            if (hasError) {
                WiFiPort.this.setState(102);
                WiFiPort.this.close();
                Log.v((String)"wifitest", (String)"failed");
            } else {
                WiFiPort.this.setState(101);
                Log.v((String)"wifitest", (String)"success");
            }
        }
    }
}

