/*
 * Decompiled with CFR 0.152.
 */
package com.android.print.sdk.wifi;

import android.content.Context;
import android.net.DhcpInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.util.Log;
import java.util.List;

public class WifiAdmin {
    private static final String TAG = "[WifiAdmin]";
    private WifiManager mWifiManager;
    private WifiInfo mWifiInfo;
    private List<ScanResult> mWifiList = null;
    private List<WifiConfiguration> mWifiConfiguration;
    private WifiManager.WifiLock mWifiLock;
    private DhcpInfo dhcpInfo;

    public WifiAdmin(Context context) {
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
    }

    public boolean openWifi() {
        if (!this.mWifiManager.isWifiEnabled()) {
            Log.i((String)TAG, (String)"setWifiEnabled.....");
            this.mWifiManager.setWifiEnabled(true);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Log.i((String)TAG, (String)"setWifiEnabled.....end");
        }
        return this.mWifiManager.isWifiEnabled();
    }

    public void closeWifi() {
        if (this.mWifiManager.isWifiEnabled()) {
            this.mWifiManager.setWifiEnabled(false);
        }
    }

    public int checkState() {
        return this.mWifiManager.getWifiState();
    }

    public void acquireWifiLock() {
        this.mWifiLock.acquire();
    }

    public void releaseWifiLock() {
        if (this.mWifiLock.isHeld()) {
            this.mWifiLock.acquire();
        }
    }

    public void creatWifiLock() {
        this.mWifiLock = this.mWifiManager.createWifiLock("Test");
    }

    public List<WifiConfiguration> getConfiguration() {
        return this.mWifiConfiguration;
    }

    public void connectConfiguration(int index) {
        if (index > this.mWifiConfiguration.size()) {
            return;
        }
        this.mWifiManager.enableNetwork(this.mWifiConfiguration.get((int)index).networkId, true);
    }

    public void startScan() {
        boolean scan = this.mWifiManager.startScan();
        Log.i((String)TAG, (String)("startScan result:" + scan));
        this.mWifiList = this.mWifiManager.getScanResults();
        this.mWifiConfiguration = this.mWifiManager.getConfiguredNetworks();
        if (this.mWifiList != null) {
            Log.i((String)TAG, (String)("startScan result:" + this.mWifiList.size()));
            int i = 0;
            while (i < this.mWifiList.size()) {
                ScanResult result = this.mWifiList.get(i);
                Log.i((String)TAG, (String)("startScan result[" + i + "]" + result.SSID + "," + result.BSSID));
                ++i;
            }
            Log.i((String)TAG, (String)"startScan result end.");
        } else {
            Log.i((String)TAG, (String)"startScan result is null.");
        }
    }

    public List<ScanResult> getWifiList() {
        return this.mWifiList;
    }

    public StringBuilder lookUpScan() {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < this.mWifiList.size()) {
            stringBuilder.append("Index_" + new Integer(i + 1).toString() + ":");
            stringBuilder.append(this.mWifiList.get(i).toString());
            stringBuilder.append("/n");
            ++i;
        }
        return stringBuilder;
    }

    public String getMacAddress() {
        return this.mWifiInfo == null ? "NULL" : this.mWifiInfo.getMacAddress();
    }

    public String getBSSID() {
        return this.mWifiInfo == null ? "NULL" : this.mWifiInfo.getBSSID();
    }

    public DhcpInfo getDhcpInfo() {
        this.dhcpInfo = this.mWifiManager.getDhcpInfo();
        return this.dhcpInfo;
    }

    public int getIPAddress() {
        return this.mWifiInfo == null ? 0 : this.mWifiInfo.getIpAddress();
    }

    public int getNetworkId() {
        return this.mWifiInfo == null ? 0 : this.mWifiInfo.getNetworkId();
    }

    public WifiInfo getWifiInfo() {
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        return this.mWifiInfo;
    }

    public boolean addNetwork(WifiConfiguration wcg) {
        int wcgID = this.mWifiManager.addNetwork(wcg);
        boolean b = this.mWifiManager.enableNetwork(wcgID, true);
        try {
            Thread.sleep(8000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void disconnectWifi(int netId) {
        this.mWifiManager.disableNetwork(netId);
        this.mWifiManager.disconnect();
    }

    public WifiConfiguration CreateWifiInfo(String SSID, String Password, int Type2) {
        Log.i((String)TAG, (String)("SSID:" + SSID + ",password:" + Password));
        WifiConfiguration config = new WifiConfiguration();
        config.allowedAuthAlgorithms.clear();
        config.allowedGroupCiphers.clear();
        config.allowedKeyManagement.clear();
        config.allowedPairwiseCiphers.clear();
        config.allowedProtocols.clear();
        config.SSID = "\"" + SSID + "\"";
        WifiConfiguration tempConfig = this.IsExsits(SSID);
        if (tempConfig != null) {
            this.mWifiManager.removeNetwork(tempConfig.networkId);
        } else {
            Log.i((String)TAG, (String)"IsExsits is null.");
        }
        if (Type2 == 1) {
            Log.i((String)TAG, (String)"Type =1.");
            config.wepKeys[0] = "";
            config.allowedKeyManagement.set(0);
            config.wepTxKeyIndex = 0;
        }
        if (Type2 == 2) {
            Log.i((String)TAG, (String)"Type =2.");
            config.hiddenSSID = true;
            config.wepKeys[0] = "\"" + Password + "\"";
            config.allowedAuthAlgorithms.set(1);
            config.allowedGroupCiphers.set(3);
            config.allowedGroupCiphers.set(2);
            config.allowedGroupCiphers.set(0);
            config.allowedGroupCiphers.set(1);
            config.allowedKeyManagement.set(0);
            config.wepTxKeyIndex = 0;
        }
        if (Type2 == 3) {
            Log.i((String)TAG, (String)"Type =3.");
            config.preSharedKey = "\"" + Password + "\"";
            config.hiddenSSID = true;
            config.allowedAuthAlgorithms.set(0);
            config.allowedGroupCiphers.set(2);
            config.allowedKeyManagement.set(1);
            config.allowedPairwiseCiphers.set(1);
            config.allowedGroupCiphers.set(3);
            config.allowedPairwiseCiphers.set(2);
            config.status = 2;
        }
        return config;
    }

    private WifiConfiguration IsExsits(String SSID) {
        List existingConfigs = this.mWifiManager.getConfiguredNetworks();
        for (WifiConfiguration existingConfig : existingConfigs) {
            if (!existingConfig.SSID.equals("\"" + SSID + "\"")) continue;
            return existingConfig;
        }
        return null;
    }

    public String intToIp(int i) {
        return String.valueOf(i & 0xFF) + "." + (i >> 8 & 0xFF) + "." + (i >> 16 & 0xFF) + "." + (i >> 24 & 0xFF);
    }
}

